using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.Security.AntiXss;
using System.Web.UI;
using System.Web.UI.WebControls;

using VIRP_WEB.Controls.Custom.EFR.Controls;

using VIRP;
using VIRP.CRS.BO;
using VIRP.EFR.BO;
using VIRP.CRS.BLL;
using VIRP.EFR.BLL;
using VIRP.EFR.UTIL;

namespace VIRP_WEB.Custom.EFR
{
    public partial class BioLabInterpretation : InterpretationBasePage
    {
        private const string ReferralKey = "BioLabInterpretation_Referrer";

        private static IReadOnlyList<string> navigationSources = new List<string>
        {
            "/Custom/EFR/InterpretationAndFollowUp/LabResultsInterpretation.aspx",
            "/Custom/EFR/InterpretationAndFollowUp/LabResultsInterpretationLetters.aspx",
            "/Custom/EFR/Patients/PatientWorkflows.aspx"
        };

        private readonly LabResultsInterpretationManager labResultsInterpretationManager;

        private WKF_CASE_ACTIVITY activity;
        private WKF_CASE_ACTIVITY labKit;
        private WKF_CASE wCase;
        private STD_WKFACTIVITYSTS activityStatus;
        private PatientDetails patientDetails;

        public BioLabInterpretation()
        {
            labResultsInterpretationManager = new LabResultsInterpretationManager();
        }

        protected override void Page_Load(object sender, EventArgs e)
        {
            NavigationSources = navigationSources;

            LabResultInterpretation1.OnCancelClick += LabResultInterpretation1_OnCancelClick;
            LabResultInterpretation1.OnSaveClick += LabResultInterpretation1_OnSaveClick;
            LabResultInterpretation1.OnInterpretComplete += LabResultInterpretation1_OnInterpretComplete;
            LabResultInterpretation1.OnPrintPatientLetter += LabResultInterpretation1_OnPrintPatientLetter;
            LabResultInterpretation1.OnPrintProviderLetter += LabResultInterpretation1_OnPrintProviderLetter;
            LabResultInterpretation1.OnAddPrintQueue += LabResultInterpretation1_OnAddPrintQueue;
            lblSaveConfirmation.Visible = false;

            if (!IsPostBack)
            {
                int CaseId = Convert.ToInt32(AntiXssEncoder.HtmlEncode(Request.QueryString["CaseId"], false));
                LoadObjectDataSourceProperties();
                BindData(CaseId);

                SetOriginalReferringPage(ReferralKey);
                SetReferringPage();
            }
        }

        private void LoadObjectDataSourceProperties()
        {
            ObjectDataSourceTestUnits.SelectParameters["CURRENT_USER"].DefaultValue = CurrentUser;
            ObjectDataSourceTestUnits.SelectParameters["CURRENT_REGISTRY_ID"].DefaultValue = CurrentRegistryId.ToString();
            ObjectDataSourceTestUnits.DataBind();
        }

        void LabResultInterpretation1_OnPrintProviderLetter(object sender, EventArgs e)
        {
            Deserialize();

            if (GetInterpretationActivity(wCase).STD_WKFACTIVITYSTS_ID != Convert.ToInt16(WorkflowCaseActivityStatus.Interpreted)) SaveData(() => "Print");

            Response.Redirect(string.Format("LabResultsInterpretationLetters.aspx?activityId={0}&intActivityId={1}&RptType={2}&CaseId={3}", GetLabResult(wCase).WKF_CASE_ACTIVITY_ID, GetInterpretationActivity(wCase).WKF_CASE_ACTIVITY_ID, "1", wCase.WKF_CASE_ID));
        }

        void LabResultInterpretation1_OnPrintPatientLetter(object sender, EventArgs e)
        {
            Deserialize();

            if (GetInterpretationActivity(wCase).STD_WKFACTIVITYSTS_ID != Convert.ToInt16(WorkflowCaseActivityStatus.Interpreted)) SaveData(() => "Print");

            Response.Redirect(string.Format("LabResultsInterpretationLetters.aspx?activityId={0}&intActivityId={1}&RptType={2}&CaseId={3}", GetLabResult(wCase).WKF_CASE_ACTIVITY_ID, GetInterpretationActivity(wCase).WKF_CASE_ACTIVITY_ID, "0", wCase.WKF_CASE_ID));
        }

        void LabResultInterpretation1_OnInterpretComplete(object sender, EventArgs e)
        {
            Deserialize();

            SaveData(() => "Interpret");

            BindData(wCase.WKF_CASE_ID);

            var activity = WKF_CASE_ACTIVITYManager.GetitemsByWorkflowCaseId(CurrentUser, CurrentRegistryId, wCase.WKF_CASE_ID)
                .Where(a => a.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.Interpretation) && a.ARCHIVED_FLAG == false)
                .FirstOrDefault();

            var letter = INTERPRETATION_LETTERManager.GetItemByWkfCaseActivityId(CurrentUser, CurrentRegistryId, activity.WKF_CASE_ACTIVITY_ID);

            if (activity != null && letter != null)
                labResultsInterpretationManager.UpdateInterpretationLetterPrintQueue(CurrentUser, CurrentRegistryId, letter, false);
        }

        void LabResultInterpretation1_OnCancelClick(object sender, EventArgs e)
        {
            Redirect();
        }

        void LabResultInterpretation1_OnSaveClick(object sender, EventArgs e)
        {
            if (Page.IsValid)
            {
                Deserialize();
                SaveData(() => "Save");
                BindData(wCase.WKF_CASE_ID);
            }
        }

        private void SaveData(Func<string> action)
        {
            Deserialize();

            PatientLabInfo info = new PatientLabInfo();

            OpenCloseReferralAndWorkflowCase(action, wCase, patientDetails.PATIENT_ICN);

            if (action() == "Interpret")
                CreateNewContact(patientDetails, wCase.REFERRAL_ID.Value);

            BioLabResultUserControl1.GetfieldValues(info);

            // Save interpretation results and addresses
            activity.CONTACT_NAME = info.LabContact;

            var specimens = SPECIMEN_ANALYSISManager.GetItemsByActivity(CurrentUser, CurrentRegistryId, activity.WKF_CASE_ACTIVITY_ID);

            if (specimens != null && specimens.Any())
            {
                var specimen = specimens.FirstOrDefault();

                specimen.LAB_UID_NUMBER = info.Accession;
                specimen.SPECIMEN_COLLECTION_DATE = StringUtility.TryGetValueFromString<DateTime>(info.SpecColnDate);

                var analysisDetails = ANALYSIS_DETAILManager.GetItemsBySpecimenId(CurrentUser, CurrentRegistryId, specimen.SPECIMEN_ANALYSIS_ID);

                if (analysisDetails != null && analysisDetails.Any())
                {
                    for (int i = 0; i < RepeaterAnalyteList.Items.Count; i++)
                    {
                        HiddenField hiddenFieldAnalysisDetailId = (HiddenField)RepeaterAnalyteList.Items[i].FindControl("HiddenFieldAnalysisDetailId");

                        // get the ANALYSIS_DETAIL entity baseed on hiddenFieldAnalysisDetailId
                        ANALYSIS_DETAIL foundAnalysisDetail = null;
                        int? detailId = !string.IsNullOrEmpty(hiddenFieldAnalysisDetailId.Value) ? int.Parse(hiddenFieldAnalysisDetailId.Value) : (int?)null;
                        if (detailId.HasValue)
                            foundAnalysisDetail = ANALYSIS_DETAILManager.GetItem(CurrentUser, CurrentRegistryId, detailId.Value);

                        if (foundAnalysisDetail != null)
                        {
                            TextBox textBoxTEFSCReferenceRange = (TextBox)RepeaterAnalyteList.Items[i].FindControl("TextBoxTEFSCReferenceRange");
                            DropDownList dropDownListTEFSCReferenceRangeUnits = (DropDownList)RepeaterAnalyteList.Items[i].FindControl("DropDownListTEFSCReferenceRangeUnits");
                            RadioButtonList radioButtonListAboveTEFSCRefenceRange = (RadioButtonList)RepeaterAnalyteList.Items[i].FindControl("RadioButtonListAboveTEFSCRefenceRange");

                            if (textBoxTEFSCReferenceRange != null)
                                foundAnalysisDetail.TEFSC_REFERENCE_RANGE = textBoxTEFSCReferenceRange.Text;

                            if (dropDownListTEFSCReferenceRangeUnits != null)
                                foundAnalysisDetail.TEFSC_REFERENCE_RANGE_UNIT_ID = StringUtility.TryGetValueFromString<int>(dropDownListTEFSCReferenceRangeUnits.SelectedValue);

                            if (radioButtonListAboveTEFSCRefenceRange != null)
                                foundAnalysisDetail.TEFSC_ABOVE_REFERENCE_RANGE = StringUtility.TryGetValueFromString<int>(radioButtonListAboveTEFSCRefenceRange.SelectedValue);

                            ANALYSIS_DETAILManager.Save(CurrentUser, CurrentRegistryId, foundAnalysisDetail);
                        }
                    }
                }
            }

            // Check if the pre-populated patient address has been changed.
            LabResultInterpretation1.UpdateInterpretationDetails(CurrentUser, CurrentRegistryId, wCase);
            LabResultInterpretation1.SaveBioFollowUp(CurrentUser, CurrentRegistryId, wCase);

            UpdateInterpretationActivity(action);

            SetSaveSuccessMessage();
        }

        private void UpdateInterpretationActivity(Func<string> action)
        {
            WKF_CASE_ACTIVITY activity = GetInterpretationActivity(wCase);

            if (activity == null)
                return;

            activity.STD_WKFACTIVITYSTS_ID = (int)WorkflowCaseActivityStatus.InProcess;

            if (action() == "Interpret" || (action() == "Save" && activity.STD_WKFACTIVITYSTS_ID == (int)WorkflowCaseActivityStatus.Interpreted))
                activity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(WorkflowCaseActivityStatus.Interpreted);

            labResultsInterpretationManager.UpdateInterpretationActivity(CurrentUser, CurrentRegistryId, activity);
        }

        void LabResultInterpretation1_OnAddPrintQueue(object sender, EventArgs e)
        {
            Deserialize();

            var activity = WKF_CASE_ACTIVITYManager.GetitemsByWorkflowCaseId(CurrentUser, CurrentRegistryId, wCase.WKF_CASE_ID)
                .Where(a => a.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.Interpretation) && a.ARCHIVED_FLAG == false)
                .FirstOrDefault();

            var letter = INTERPRETATION_LETTERManager.GetItemByWkfCaseActivityId(CurrentUser, CurrentRegistryId, activity.WKF_CASE_ACTIVITY_ID);

            if (activity.STD_WKFACTIVITYSTS_ID != Convert.ToInt16(WorkflowCaseActivityStatus.Interpreted)) SaveData(() => "Print");
            if (activity != null && letter != null)
                labResultsInterpretationManager.UpdateInterpretationLetterPrintQueue(CurrentUser, CurrentRegistryId, letter, true);
        }

        private void BindData(int caseId)
        {
            wCase = labResultsInterpretationManager.GetLabInterpretationDetails(CurrentUser, CurrentRegistryId, caseId);
            if (wCase == null) return;

            activity = GetLabResult(wCase);

            labKit = WKF_CASE_ACTIVITYManager.SelectByActivityType(CurrentUser, CurrentRegistryId, wCase.WKF_CASE_ID, "LabKit");

            ViewState["labKit"] = labKit.Serialize();
            ViewState["wCase"] = wCase.Serialize();

            PatientDetails patientDetails = PatientDetailsManager.GetItem(CurrentUser, CurrentRegistryId, wCase.PATIENT_ID);
            ViewState["PatientDetails"] = patientDetails.Serialize();

            PatientLabInfo Info = new PatientLabInfo();

            if (activity != null)
            {
                Info.WorkFlowCaseId = "";
                Info.Name = patientDetails.FULL_NAME;
                Info.ID = patientDetails.ToString();
                Info.ICN = patientDetails.PATIENT_ICN;
                Info.Snum = patientDetails.Snum;
                Info.BirthDate = ConvertDateToString(patientDetails.BIRTH_DATE);
                Info.Gender = patientDetails.GENDER;
                Info.PostalCode = patientDetails.POSTAL_CODE;

                var specimens = SPECIMEN_ANALYSISManager.GetItemsByActivity(CurrentUser, CurrentRegistryId, activity.WKF_CASE_ACTIVITY_ID);
                if (specimens != null && specimens.Any())
                {
                    var specimen = specimens.FirstOrDefault();

                    Info.ReportDate = ConvertDateToString(specimen.LAB_REPORT_DATE);
                    Info.Accession = specimen.LAB_UID_NUMBER;

                    Info.LabName = specimen.LAB_NAME;
                    if (Info.LabName == null)
                        Info.LabName = "Baltimore VA lab";
                    Info.SpecColnDate = ConvertDateToString(specimen.SPECIMEN_COLLECTION_DATE);
                    lblElapsedTime.Text = specimen.TIME_ELAPSED_NUMBER;
                    lblTotalVol.Text = specimen.TOTAL_VOLUME_NUMBER;
                    lblVolOfAnalyteTests.Text = specimen.ANALYTE_VOLUME_NUMBER;

                    // Populate Analyte details
                    var analysisDetails = ANALYSIS_DETAILManager.GetItemsBySpecimenId(CurrentUser, CurrentRegistryId, specimen.SPECIMEN_ANALYSIS_ID);
                    if (analysisDetails != null && analysisDetails.Any())
                    {
                        RepeaterAnalyteList.DataSource = analysisDetails.OrderBy(ad => ANALYSIS_DETAIL_SORT.SortByLabResults(ad));
                        RepeaterAnalyteList.DataBind();
                    }
                }

                // Bind provider,patient details
                // Populate patient updated address
                LabResultInterpretation1.PopulatePatientProviderDetails(CurrentUser, CurrentRegistryId, wCase, "Bio");
                LabResultInterpretation1.PopulateBioFollowUp(CurrentUser, CurrentRegistryId, wCase);

                Info.LabContact = activity.CONTACT_NAME;
                 
                if (labKit != null)
                {
                    Info.KitReceivedDate = string.Empty;

                    var shippingDetails = SHIPPING_DETAILManager.GetItemsByActivity(CurrentUser, CurrentRegistryId, labKit.WKF_CASE_ACTIVITY_ID);
                    if (shippingDetails != null && shippingDetails.Any())
                    {
                        var detail = shippingDetails.FirstOrDefault();
                        if (detail != null && detail.RECEIVED_DATE.HasValue)
                            Info.KitReceivedDate = detail.RECEIVED_DATE.Value.ToString("d");
                    }
                }

                var intActivity = WKF_CASE_ACTIVITYManager.GetitemsByWorkflowCaseId(CurrentUser, CurrentRegistryId, wCase.WKF_CASE_ID)
                    .Where(a => a.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.Interpretation) && a.ARCHIVED_FLAG == false)
                    .FirstOrDefault();
                activityStatus = intActivity.STD_WKFACTIVITYSTS;
                ViewState["OrderType"] = activityStatus.ID;

                bool linkwfs = intActivity.STD_WKFACTIVITYSTS_ID == (int)WorkflowCaseActivityStatus.New ||
                     intActivity.STD_WKFACTIVITYSTS_ID == (int)WorkflowCaseActivityStatus.InProcess;

                BioLabResultUserControl1.SetfieldValues(Info, linkwfs);

                ReplacePageTitle("Interpretation & Follow Up > " + activityStatus.NAME + " > Workflow ID " + wCase.WKF_CASE_ID.ToString());
            }
        }

        protected void RepeaterAnalyteList_ItemDataBound(object sender, RepeaterItemEventArgs e)
        {
            if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
            {
                DropDownList dropDownListTEFSCReferenceRangeUnits = e.Item.FindControl("DropDownListTEFSCReferenceRangeUnits") as DropDownList;
                Panel panelAboveTEFSCReferenceRange = e.Item.FindControl("PanelAboveTEFSCReferenceRange") as Panel;
                RequiredFieldValidator requiredFieldValidatorForRadioButtonListAboveTEFSCRefenceRange = e.Item.FindControl("RequiredFieldValidatorForRadioButtonListAboveTEFSCRefenceRange") as RequiredFieldValidator;
                Label labelLabReferenceRange = e.Item.FindControl("LabelLabReferenceRange") as Label;
                Label labelLabAboveReferenceRange = e.Item.FindControl("LabelLabAboveReferenceRange") as Label;
                Label labelResultReferenceUnit = e.Item.FindControl("LabelResultReferenceUnit") as Label;

                ANALYSIS_DETAIL currentAnalysisDetail = (ANALYSIS_DETAIL)e.Item.DataItem;

                //set the TEFSC reference range unit drop down
                if (currentAnalysisDetail.TEFSC_REFERENCE_RANGE_UNIT_ID.HasValue && dropDownListTEFSCReferenceRangeUnits != null)
                    dropDownListTEFSCReferenceRangeUnits.SelectedValue = currentAnalysisDetail.STD_UNIT1.ID.ToString();

                //set the above TEFSC reference range radio button list value
                if (currentAnalysisDetail.TEFSC_ABOVE_REFERENCE_RANGE.HasValue)
                {
                    RadioButtonList radioButtonListAboveTEFSCRefenceRange = e.Item.FindControl("RadioButtonListAboveTEFSCRefenceRange") as RadioButtonList;
                    if (radioButtonListAboveTEFSCRefenceRange != null)
                        radioButtonListAboveTEFSCRefenceRange.SelectedValue = currentAnalysisDetail.TEFSC_ABOVE_REFERENCE_RANGE.Value.ToString();
                }

                if (currentAnalysisDetail.LAB_REFERENCE_RANGE == "" && labelResultReferenceUnit != null && labelLabReferenceRange != null) 
                {
                    labelLabReferenceRange.Text
                    = labelResultReferenceUnit.Text
                    = "N/A";
                }

                bool ShowTEFSCReferenceRangeReadOnly = true;

                Label labelforTextBoxTEFSCReferenceRange = e.Item.FindControl("LabelforTextBoxTEFSCReferenceRange") as Label;
                Label labelforLabelTEFSCReferenceRange = e.Item.FindControl("LabelforLabelTEFSCReferenceRange") as Label;
                TextBox textBoxTEFSCReferenceRange = e.Item.FindControl("TextBoxTEFSCReferenceRange") as TextBox;
                Label labelTEFSCReferenceRange = e.Item.FindControl("LabelTEFSCReferenceRange") as Label;
                Label labelforDropDownListTEFSCReferenceRangeUnits = e.Item.FindControl("LabelforDropDownListTEFSCReferenceRangeUnits") as Label;
                Label labelforLabelTEFSCReferenceRangeUnits = e.Item.FindControl("LabelforLabelTEFSCReferenceRangeUnits") as Label;
                Label labelTEFSCReferenceRangeUnits = e.Item.FindControl("LabelTEFSCReferenceRangeUnits") as Label;

                string analyteTypeCode = null;
                if (currentAnalysisDetail.STD_ANALYTETYPE != null)
                    analyteTypeCode = currentAnalysisDetail.STD_ANALYTETYPE.CODE;

                if (currentAnalysisDetail.STD_ANALYTETYPE_ID == null || (!string.IsNullOrEmpty(analyteTypeCode) && analyteTypeCode == "OTHER"))
                    ShowTEFSCReferenceRangeReadOnly = false;
                else
                    ShowTEFSCReferenceRangeReadOnly = true;

                //show TEFSC reference range read only label and associated controls
                if (labelTEFSCReferenceRange != null && labelforLabelTEFSCReferenceRangeUnits != null && labelTEFSCReferenceRangeUnits != null && labelforLabelTEFSCReferenceRange != null)
                {
                    labelforLabelTEFSCReferenceRange.Visible
                        = labelTEFSCReferenceRange.Visible
                        = labelforLabelTEFSCReferenceRangeUnits.Visible
                        = labelTEFSCReferenceRangeUnits.Visible
                        = ShowTEFSCReferenceRangeReadOnly;
                }

                //show TEFSC reference range text box and associated controls
                if (textBoxTEFSCReferenceRange != null && labelforDropDownListTEFSCReferenceRangeUnits != null && dropDownListTEFSCReferenceRangeUnits != null && labelforTextBoxTEFSCReferenceRange != null)
                {
                    labelforTextBoxTEFSCReferenceRange.Visible
                    = textBoxTEFSCReferenceRange.Visible
                    = labelforDropDownListTEFSCReferenceRangeUnits.Visible
                    = dropDownListTEFSCReferenceRangeUnits.Visible
                    = !ShowTEFSCReferenceRangeReadOnly;
                }

                string testCode = null;
                if (currentAnalysisDetail.STD_TEST_NAME != null)
                    testCode = currentAnalysisDetail.STD_TEST_NAME.CODE;

                if (!string.IsNullOrEmpty(testCode) && testCode == "STANDARDIZED")
                {
                    if (panelAboveTEFSCReferenceRange != null)
                        panelAboveTEFSCReferenceRange.Visible = true;

                    if (requiredFieldValidatorForRadioButtonListAboveTEFSCRefenceRange != null)
                    {
                        requiredFieldValidatorForRadioButtonListAboveTEFSCRefenceRange.Enabled = true;
                        requiredFieldValidatorForRadioButtonListAboveTEFSCRefenceRange.ErrorMessage = "Above TEFSC Reference Range Required for " + testCode + " " + currentAnalysisDetail.ANALYTE_NAME;
                    }
                }
                else
                {
                    if (panelAboveTEFSCReferenceRange != null)
                        panelAboveTEFSCReferenceRange.Visible = false;
                    if (requiredFieldValidatorForRadioButtonListAboveTEFSCRefenceRange != null)
                        requiredFieldValidatorForRadioButtonListAboveTEFSCRefenceRange.Enabled = false;
                }
            }
        }

        private void Deserialize()
        {
            wCase = SerializerUtility.Deserialize<WKF_CASE>((string)ViewState["wCase"]);
            patientDetails = SerializerUtility.Deserialize<PatientDetails>((string)ViewState["PatientDetails"]);
            activity = GetLabResult(wCase);
        }

        private void Redirect()
        {
            RedirectToOriginalReferringPage(ReferralKey);
        }
    }
}
